\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{frcmanual}[FRENCO GmbH Manual Template]

\RequirePackage{kvoptions}
\RequirePackage{ifthen}
\RequirePackage{ifluatex}
\RequirePackage{ifxetex}

\date{\today}
\author{FRENCO GmbH}

\DeclareStringOption[de]{lang}
\ProcessKeyvalOptions*
\ProcessOptions\relax

\providecommand{\lang}{\frcmanual@lang}

\LoadClass[
	11pt,
	a4paper,
	oneside,
]{scrbook}


% Für richtiges Typesetting und sprachenspezifische Anführungszeichen
\ifluatex
	\RequirePackage{fontspec}
	\setmainfont{PT Serif}  % paratype Serif
	% \setsansfont{PT Sans} % paratype Sans-Serif
	% \setmonofont{PT Mono} % paratype Monospace
	% \setsansfont{TeX Gyre Heros} % helvetica (Sans-Serif)
\else\ifxetex
	\RequirePackage{fontspec}
	\setmainfont{PT Serif}  % paratype Serif
	% \setsansfont{PT Sans} % paratype Sans-Serif
	% \setmonofont{PT Mono} % paratype Monospace
	% \setsansfont{TeX Gyre Heros} % helvetica (Sans-Serif)
\else
	\RequirePackage[T1]{fontenc}
	\RequirePackage[utf8]{inputenc}

	% Paratype fonts haben keinen frontspec support.
	\RequirePackage{PTSerif} % paratype (open-source klon) als serifen Schriftart
	%\RequirePackage{PTSans} % paratype (open-source klon) als sans-serif Schriftart
	%\RequirePackage{PTMono} % paratype (open-source klon) als monospace Schriftart

	% Helvet hat keinen fontspec support
	%\RequirePackage{helvet} % helvetica (open-source klon) als sans-serif Schriftart
\fi\fi

% carlit und FiraMono berücksichtigen den LaTeX Compiler bereits, keine Fallunterscheidung notwendig.
\RequirePackage[lf]{carlito} % calibri (open-source klon) als sans-serif Schriftart
\RequirePackage[scale=0.88]{FiraMono} % Fira Mono (open-source) als monospace Schriftart

\renewcommand{\familydefault}{\sfdefault} % Fließtext in sans-serif

% Unterstützte Sprachen für den Lang Parameter der LaTeX Klasse
% WICHTIG: Slogan auf Titlepage weiter unten hinzufügen, wenn neue Sprache eingetragen wird.
\ifthenelse{\equal{\frcmanual@lang}{de}}{\RequirePackage[ngerman]{babel}}{}
\ifthenelse{\equal{\frcmanual@lang}{en}}{\RequirePackage[english]{babel}}{}
\ifthenelse{\equal{\frcmanual@lang}{fr}}{\RequirePackage[french]{babel}}{}


\RequirePackage{microtype} % bessere typographie
\RequirePackage{scrlayer-scrpage} % für pagestyle anpassung
\RequirePackage{parskip}
\RequirePackage[useregional]{datetime2}
\RequirePackage{amsmath}
\RequirePackage{amssymb}
\RequirePackage{amsfonts}
\RequirePackage{textcomp}
\RequirePackage{geometry}
\RequirePackage[babel=true]{csquotes}
\RequirePackage{graphicx}
\RequirePackage{multicol}
\RequirePackage{svg}
\RequirePackage{xurl}
\RequirePackage{xcolor}
\RequirePackage{subcaption}
\RequirePackage{pdfpages}
\RequirePackage{pgfplots}
\RequirePackage{enumitem}
\RequirePackage{tikz}
\RequirePackage{tabularray}
\RequirePackage[most]{tcolorbox}
\RequirePackage{minted}
\RequirePackage{etoolbox}
\RequirePackage{appendix}

\RequirePackage{hyperref}

% Farben
\definecolor{frcblue}{RGB}{0, 66, 127}
\definecolor{frcgreen}{RGB}{34, 139, 34}
\definecolor{frcred}{RGB}{228, 4, 45}


\hypersetup{
	pdftitle = {\@title},
	pdfauthor = {\@author},
	pdfpagelabels = true,
	allcolors = frcblue,
	allbordercolors = frcblue,
	colorlinks = true, % border nur sichtbar, wenn false
	pdfborderstyle={/S/U/W 1}, % underline mit höhe 1pt
}

% Shortcuts
\newcommand\blit[1]{\textcolor{frcblue}{\textit{#1}}} % blue & italic
\newcommand\blbf[1]{\textcolor{frcblue}{\textbf{#1}}} % blue & bold
\newcommand\bl[1]{\textcolor{frcblue}{#1}} % blue

% Commands
\newcommand\version[1]{\def\@version{#1}}
\newcommand\theversion{\@version}
\newcommand\titleimage[1]{\def\@titleimage{#1}}
\newcommand\titlesvg[1]{\def\@titlesvg{#1}}
\def\@titleimagewidth{0.8\textwidth}
\newcommand\titleimagewidth[1]{\def\@titleimagewidth{#1}}

% Innere Seitenränder nach DIN 5008 wäre 2cm bin 2.5cm
\geometry{
	a4paper,
	left=2cm,
	right=2cm,
	top=1.5cm,
	bottom=1.5cm,
	headsep = \baselineskip,
	footskip = \dimexpr2\baselineskip+3mm\relax,
	includeheadfoot,
}

\pagestyle{scrheadings}  % Aktiviert scrheadings für das gesamte Dokument
\renewcommand{\chapterpagestyle}{scrheadings}

\KOMAoptions{
	headsepline = true,
	footsepline = true,
	plainfootsepline = true,
	plainheadsepline = true,
}
\setkomafont{pageheadfoot}{\footnotesize}
\setkomafont{pagehead}{\footnotesize}

% Innen- und Außenseite bezieht sich auf Doppelseitige Dokumente
\ihead*{\textbf{\textsf{\@author}}} % innenseite
\chead*{\textbf{\textsf{\@title}}} % center
\ohead{\ifthenelse{\isundefined{\@version}}{Test}{\@version}} % außenseite

\ifoot*{\headmark} % innenseite
\cfoot*{\pagemark} % center
\ofoot*{\@date} % außenseite

% Reduzierter Platz vor Chapter Überschrift
\renewcommand*{\chapterheadstartvskip}{\vspace*{0.5cm}}


\pgfplotsset{compat=1.18} % Setzte pgfplotset Version
\setlist{itemsep=-0.2em} %em = Zeilenhöhe. Reduzierter Zeilenabstand bei Itemize und Enumerate
\setlist[enumerate]{font=\ttfamily} % Monospace Schriftart für Nummern von Enumerates
\def \parskiplength {0.5em} % Einheitlicher Abstand nach Paragraphen (Variable, da auch für tcolorbox verwendet)
\setlength{\parskip}{\parskiplength} % Abstand nach Paragraphen
\setlength{\parindent}{0pt} % Einrücktiefe eines Paragraphen
\usetikzlibrary{shapes, arrows}
\renewcommand{\arraystretch}{1.2} % Für Padding zwischen Text und Linien 
\setminted{ % Codehighlighting
	%linenos,
	tabsize=4,
	breaklines,
	resetmargins=true,
	fontsize=\footnotesize,
}
\setmintedinline{
	tabsize=4,
	breaklines,
	fontsize=\normalsize,
}




\ifdefined\HCode
	% TeX4ht Durchgang
	
	% Falls es Probleme mit tikz und HTML gibt, könnte die folgende Zeile helfen
	% \def\pgfsysdriver{pgfsys-dvisvgm4ht.def}
	

	% Dieses renewcommand könnte zu Problemen führen.
	% Es ist aber (noch) notwendig, da tex4ht in Tabellen die linewidth nicht korrekt berechnet.
	% \textwidth wird im HTML zu "width: 100%", daher ist das ein Hack um Tabellen zu unterstützen.
	\renewcommand{\linewidth}{\textwidth}

	% Border in Minted envs wird über CSS hinzugefügt
	% TeX4ht hat Probleme mit geschachtelter tcolorbox

	% Eingekreister Text
	\newcommand*\circled[1]{\HCode{<span class="circled">}#1\HCode{</span>}}


	% Text mit Grünem Checkmark davor
	\newcommand*\frccheck[1]{\HCode{<span class="frccheck">✓</span>}~#1}

\else
	% Normaler Pdf Durchgang

	% linewidth bleibt linewidth im Pdf Durchgang

	% Für bessere Anpassbarkeit wird eine tcolorbox als minted environment verwendet
	\BeforeBeginEnvironment{minted}%
	{\begin{tcolorbox}[
		arc=2pt,
		breakable,
		enhanced jigsaw,
		autoparskip,
		leftrule=0.6pt,
		toprule=0.6pt,
		bottomrule=0.6pt,
		rightrule=0.6pt,
		left=1mm,
		right=1mm,
		opacityback=0,
		colframe=black,
		top=1mm,
		bottom=0.2mm,
	]}%
	\AfterEndEnvironment{minted}%
	{\end{tcolorbox}}%


	% Eingekreister Text
	\newcommand*\circled[1]{\tikz[baseline=(char.base)]{\node[shape=circle,draw,inner sep=2pt] (char) {#1};}}


	% Text mit Grünem Checkmark davor
	\newcommand*\frccheck[1]{\begin{itemize}[label={\textcolor{frcgreen}{\checkmark}}]\begin{item}{#1}\end{item}\end{itemize}}

\fi





% Style für frcbox
\tcbset {
  base/.style={
		arc=2pt, 
		bottomtitle=0.5mm,
		boxrule=0mm,
		colbacktitle=frcblue!20!white, 
		colframe=frcblue,
		coltitle=black, 
		fonttitle=\bfseries, 
		leftrule=0.6pt,
		toprule=0.6pt,
		bottomrule=0.6pt,
		rightrule=0.6pt,
		left=2.5mm,
		right=3.5mm,
		title={#1},
		toptitle=0.75mm, 
		breakable,
		enhanced,
		autoparskip,
		before upper=\setlength{\parskip}{\parskiplength}\setlength{\parindent}{0pt},
  }
}

\newtcolorbox{frcbox}[2][]{
	base={#2},
	#1 % zusätzliche Optionen
}


% Style für breakable tt boxen
% Style ist äquivalent zum Minted style
% Zusatz: Zeilenumbrüche, Worttrennung, sloppy randausgleich 
\newtcolorbox{ttbox}{
	arc=2pt,
	breakable,
	enhanced jigsaw,
	leftrule=0.6pt,
	toprule=0.6pt,
	bottomrule=0.6pt,
	rightrule=0.6pt,
	left=1mm,
	right=1mm,
	opacityback=0,
	colframe=black,
	top=1mm,
	bottom=0.2mm,
	before upper={\setlength{\parskip}{\parskiplength}\setlength{\parindent}{0pt}\ttfamily\sloppy\hyphenchar\font=`\-}
}


\NewTblrEnviron{frctable}
\SetTblrInner[frctable]{
	row{odd} = {frcblue!15!white}, 
	row{even} = {frcblue!5!white},
	row{1} = {font=\bfseries, frcblue!30!white},
	rowhead = 1,
	hline{1,Z} = {0.08em}, % toprule and bottomrule
	hline{2} = {0.05em}, % midrule  
}


\NewTblrEnviron{frclongtable}

\ifdefined\HCode
% Kein longtblr, so verhindern wir "(Continued) Continued on next page" im HTML Code
\else
\SetTblrOuter[frclongtable]{long}
\fi

\SetTblrInner[frclongtable]{
	row{odd} = {frcblue!15!white}, 
	row{even} = {frcblue!5!white},
	row{1} = {font=\bfseries, frcblue!30!white},
	rowhead = 1,
	hline{1,Z} = {0.08em}, % toprule and bottomrule
	hline{2} = {0.05em}, % midrule  
}



\renewcommand*\maketitle{
	\thispagestyle{empty}
	\begin{center}
	\begin{minipage}{0.45\textwidth}
	\includegraphics[width=0.94\textwidth]{global/logo}%
	\end{minipage}%
	\begin{minipage}{15pt}
	\textcolor{frcblue}{\rule{0.5pt}{0.2\textheight}}
	\end{minipage}%
	\begin{minipage}{0.45\textwidth}
	\Large
	\textbf{\textsf{\@author}} \\
	\normalsize
	\ifthenelse{\equal{\frcmanual@lang}{de}}{Verzahnungstechnik-Messtechnik}{}
	\ifthenelse{\equal{\frcmanual@lang}{en}}{We are dentists just more precise}{} % TODO

	\vspace*{0.5cm}
	Jakob-Baier-Straße 3 \\
	D 90518 Altdorf
	\end{minipage}
	\end{center}
	
	\begin{center}
		\vspace*{2cm}
		%\sffamily
		
		\vspace*{1cm}
		
		\Huge
		\textbf{\textcolor{frcblue}{\@title}}

		%\rmfamily
		
		\Large
		\vspace*{1cm}
		\ifthenelse{\isundefined{\@subtitle}}{}{\@subtitle}
	
		
		\vspace*{1cm}
		\@date

		\ifthenelse{\isundefined{\@version}}{}{\@version}

		\vspace*{2cm}
		\vspace*{\fill}
		\ifthenelse{\isundefined{\@titleimage}}{}{\includegraphics[width=\@titleimagewidth]{\@titleimage}}
		\ifthenelse{\isundefined{\@titlesvg}}{}{\includesvg[width=\@titleimagewidth]{\@titlesvg}}
		\vspace*{\fill}
	\end{center}
	\vfill
	\setcounter{page}{1} 
}


\makeatletter
\let\@unusedoptionlist\@empty
\@addtoreset{chapter}{part} % Reset chapter counter nach part
\makeatother
