#!/usr/bin/env perl
use strict;
use warnings;
use File::Find;
use File::Path qw(remove_tree);

# Codepage auf UTF-8 setzen, falls unter Windows
system("chcp 65001 >NUL") if $^O eq 'MSWin32';

# Latexmk zum Bereinigen der LaTeX Artefakte aufrufen
system('latexmk', '-c');

# make4ht zum Bereinigen der HTML Artefakte aufrufen
my @texfiles = glob("*.tex");
for my $texfile (@texfiles){
	system("make4ht", "-m", "clean", "-ls", "--loglevel", "debug", $texfile);
}

my @exts     = qw(synctex.gz fls ist xdy fls log html);
my @dirs     = qw(svg-inkscape _minted);

# Z.B. qr{.*/lwarp.*}
my @patterns = (qr{pre-.*\.html});

# Dateien löschen
find(
sub {
	return unless -f;
	
	for my $ext (@exts) {
		if ($File::Find::name =~ /\.\Q$ext\E$/i) {
			unlink $File::Find::name and print "Deleted file: $File::Find::name\n";
			last;
		}
	}
	
	for my $pat (@patterns) {
		if ($File::Find::name =~ $pat) {
			unlink $File::Find::name and print "Deleted file: $File::Find::name\n";
			last;
		}
	}
},
'.'
);

# Verzeichnisse löschen
for my $dir (@dirs) {
	if (-d $dir) {
		remove_tree($dir);
		print "Deleted dir: $dir\n";
	}
}
